/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.com.mongodb.util;

import java.util.Iterator;
import java.util.List;
import net.impactdev.impactor.relocations.com.mongodb.Bytes;
import net.impactdev.impactor.relocations.com.mongodb.util.AbstractObjectSerializer;
import net.impactdev.impactor.relocations.com.mongodb.util.ObjectSerializer;
import net.impactdev.impactor.relocations.org.bson.util.ClassMap;

class ClassMapBasedObjectSerializer
extends AbstractObjectSerializer {
    private final ClassMap<ObjectSerializer> _serializers = new ClassMap();

    ClassMapBasedObjectSerializer() {
    }

    void addObjectSerializer(Class c, ObjectSerializer serializer) {
        this._serializers.put(c, serializer);
    }

    @Override
    public void serialize(Object obj, StringBuilder buf) {
        Class<?> ancestor;
        Object objectToSerialize = obj;
        if ((objectToSerialize = Bytes.applyEncodingHooks(objectToSerialize)) == null) {
            buf.append(" null ");
            return;
        }
        ObjectSerializer serializer = null;
        List<Class<?>> ancestors = ClassMap.getAncestry(objectToSerialize.getClass());
        Iterator<Class<?>> iterator2 = ancestors.iterator();
        while (iterator2.hasNext() && (serializer = this._serializers.get(ancestor = iterator2.next())) == null) {
        }
        if (serializer == null && objectToSerialize.getClass().isArray()) {
            serializer = this._serializers.get(Object[].class);
        }
        if (serializer == null) {
            throw new RuntimeException("json can't serialize type : " + objectToSerialize.getClass());
        }
        serializer.serialize(objectToSerialize, buf);
    }
}

